#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
using BROKEN = gov.va.med.vbecs.Common.VbecsBrokenRules.FrmEditUnitFinancial;

#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	
	
	[TestFixture]
	public class BOL_BloodUnitFinance : BaseTest 
	{
		private System.Guid _unitGuid;
		private System.Guid _productGuid;
		private BOL.BloodUnitFinance _tstBUF;
		
		private DataTable _dtBloodUnit;
		private DataTable _dtBloodUnitFinance;
		private DataTable _dtProductShippers;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtBloodUnit = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM vw_BloodShipFinanceAllCurrent WHERE RecordStatusCode = 'A' AND OutgoingShipmentGuid IS NOT NULL AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", false);

				if (this._dtBloodUnit.Rows.Count == 0)
				{
					BOL.BloodUnit tmpUnit = DataCreator.CreateBloodUnit(true);
					string invoiceNumber = new Random().Next(1111111,9999999).ToString();
					BOL.LocalSupplier tmpLS = DataCreator.CreateLocalSupplier();
					BOL.OutgoingShipmentCollection tmpOSC = BOL.OutgoingShipmentCollection.CreateOutgoingInvoice(invoiceNumber, tmpLS.LocalSupplierGuid, DateTime.Now, Common.ShipmentType.ReturnToSupplier, Common.LogonUser.LogonUserName, Common.UpdateFunction.UnitTests);
					BOL.OutgoingShipmentCollection.LineItem lineItem = BOL.OutgoingShipmentCollection.LineItem.GetLineItemForUpdate(tmpUnit.BloodUnitGuid);
					tmpOSC.AddUnitToInvoice(lineItem);
					tmpOSC.SaveChangesToInvoiceItems(new ArrayList(), Common.UpdateFunction.UnitTests);

					this._dtBloodUnit = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM vw_BloodShipFinanceAllCurrent WHERE RecordStatusCode = 'A' AND OutgoingShipmentGuid IS NOT NULL AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);
				}


				this._unitGuid = (System.Guid)this._dtBloodUnit.Rows[0][TABLES.BloodUnit.BloodUnitGuid];
				this._productGuid = (System.Guid)this._dtBloodUnit.Rows[0][TABLES.BloodUnit.BloodProductGuid];

				this._dtBloodUnitFinance = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnitFinance WHERE BloodUnitGuid = '" + this._unitGuid.ToString() + "'", true);
				
				this._dtProductShippers = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM ProductShipper WHERE BloodProductGuid = '" + this._productGuid.ToString() + "' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);

				this.RefreshData = false;
			}
			
			this._tstBUF = new BOL.BloodUnitFinance(this._unitGuid);
			_tstBUF.SetInitialBrokenRules(BROKEN.FormClassName, BROKEN.RuleSets.Default);
		}

		[Test]
		public void Ctor_Guid_Pass()
		{
			BOL.BloodUnitFinance tmpBUF = new BOL.BloodUnitFinance(this._unitGuid);

			Assert.IsNotNull(tmpBUF);
			Assert.IsTrue(tmpBUF.BloodUnitGuid == this._unitGuid);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Guid_Fail()
		{
		}

		[Test]
		public void LoadDefaultCostInformation_Pass()
		{
			BOL.ProductShipperCollection tmpBSC = new BOL.ProductShipperCollection(this._productGuid);

			System.Guid lsGuid = (System.Guid)this._dtProductShippers.Rows[0][TABLES.ProductShipper.LocalSupplierGuid];

			BOL.ProductShipper tmpPS = new BOL.ProductShipper(this._dtProductShippers.Rows[0]);

			this._tstBUF.LoadDefaultCostInformation(tmpBSC, lsGuid);

			Assert.IsTrue(this._tstBUF.UnitCost == tmpPS.ProductCost);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LoadDefaultCostInformation_Fail()
		{
		}

		[Test]
		public void LoadBloodUnitFinancialData_Pass()
		{
			string unitId = this._dtBloodUnit.Rows[0][TABLES.BloodUnit.EyeReadableUnitId].ToString();
			string productCode = this._dtBloodUnit.Rows[0][TABLES.BloodUnit.UnitProductCode].ToString();

			BOL.BloodUnitFinance tmpBUF = new BOL.BloodUnitFinance(this._unitGuid);
			tmpBUF.LoadBloodUnitFinancialData(unitId, productCode);

			Assert.IsTrue(this._tstBUF.UnitCost == tmpBUF.UnitCost);
			Assert.IsTrue(this._tstBUF.ReturnCreditAmount == tmpBUF.ReturnCreditAmount);
			Assert.IsTrue(this._tstBUF.SpecialTestingCost == tmpBUF.SpecialTestingCost);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LoadBloodUnitFinancialData_Fail()
		{
		}

		[Test]
		public void Save_Pass()
		{
			this.RefreshData = true;

			this._tstBUF.UnitCost = (decimal)100;		//Need to set the "dirty" flag
			
			bool tstValue = this._tstBUF.Save(Common.UpdateFunction.UnitTests );
			
			Assert.IsTrue(tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Save_Fail()
		{
		}

		[Test]
		public void CalculateReturnCreditAmount_Pass()
		{
			BOL.ProductShipper tmpPS = new BOL.ProductShipper(this._dtProductShippers.Rows[0]);

			System.Guid lsGuid = (System.Guid)this._dtProductShippers.Rows[0][TABLES.ProductShipper.LocalSupplierGuid];

			decimal tstValue = this._tstBUF.CalculateReturnCreditAmount(lsGuid, this._productGuid);
			
			Assert.IsTrue(tstValue == (tmpPS.ReturnCreditPercentage / 100 * this._tstBUF.UnitCost));
		}

		[Test]
		public void CalculateReturnCreditAmount_Fail()
		{
			decimal tstValue = this._tstBUF.CalculateReturnCreditAmount(System.Guid.NewGuid(), System.Guid.NewGuid());
			Assert.IsTrue(tstValue == decimal.Zero);
		}

		[Test]
		public void GetFinancialBloodUnits_Pass()
		{
			DataTable dtTest = BOL.BloodUnitFinance.GetFinancialBloodUnits();
			Assert.IsTrue(dtTest.Rows.Count >= 0);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetFinancialBloodUnits_Fail()
		{
		}

		
		[Test]
		public void LoadDataRowFromThis_Pass()
		{
			DataRow drTest = this._tstBUF.LoadDataRowFromThis(this._dtBloodUnitFinance.NewRow());

			Assert.IsTrue(drTest[TABLES.BloodUnitFinance.BloodUnitFinanceGuid].ToString() == this._tstBUF.BloodUnitFinanceGuid.ToString());
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LoadDataRowFromThis_Fail()
		{
		}

		[Test]
		public void MaximumBaseCostValue_Pass()
		{
			decimal tstValue = BOL.BloodUnitFinance.MaximumBaseCostValue;
			Assert.IsTrue(tstValue == BOL.BloodUnitFinance.MaximumBaseCostValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void MaximumBaseCostValue_Fail()
		{
		}
		
		[Test]
		public void MaximumSpecialTestCost_Pass()
		{
			decimal tstValue = BOL.BloodUnitFinance.MaximumSpecialTestCost;
			Assert.IsTrue(tstValue == BOL.BloodUnitFinance.MaximumSpecialTestCost);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void MaximumSpecialTestCost_Fail()
		{
		}
		
		[Test]
		public void MaximumReturnCreditAmount_Pass()
		{
			decimal tstValue = BOL.BloodUnitFinance.MaximumReturnCreditAmount;
			Assert.IsTrue(tstValue == BOL.BloodUnitFinance.MaximumReturnCreditAmount);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void MaximumReturnCreditAmount_Fail()
		{
		}

		[Test]
		public void BloodUnitFinanceGuid_Pass()
		{
			System.Guid tstValue = System.Guid.NewGuid();

			this._tstBUF.BloodUnitFinanceGuid = tstValue;

			Assert.IsTrue(this._tstBUF.BloodUnitFinanceGuid == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void BloodUnitFinanceGuid_Fail()
		{
		}

		[Test]
		public void BloodUnitGuid_Pass()
		{
			System.Guid tstValue = System.Guid.NewGuid();

			this._tstBUF.BloodUnitGuid = tstValue;

			Assert.IsTrue(this._tstBUF.BloodUnitGuid == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void BloodUnitGuid_Fail()
		{
		}

		[Test]
		public void OutgoingShipmentGuid_Pass()
		{
			System.Guid tstValue = System.Guid.NewGuid();

			this._tstBUF.OutgoingShipmentGuid = tstValue;

			Assert.IsTrue(this._tstBUF.OutgoingShipmentGuid == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void OutgoingShipmentGuid_Fail()
		{
		}

		[Test]
		public void UnitCost_Pass()
		{
			this._tstBUF.UnitCost = (decimal)50;
			Assert.IsTrue(this._tstBUF.IsRuleBroken(BROKEN.UnitCost) == false);
		}

		[Test]
		public void UnitCost_Fail()
		{
			this._tstBUF.UnitCost = BOL.BloodUnitFinance.MaximumBaseCostValue + 1;

			Assert.IsTrue(this._tstBUF.IsRuleBroken(BROKEN.UnitCost));
		}
		

		[Test]
		public void SpecialTestingCost_Pass()
		{
			this._tstBUF.SpecialTestingCost = (decimal)50;
			Assert.IsTrue(this._tstBUF.IsRuleBroken(BROKEN.SpecialTestingCost) == false);	
		}


		[Test]
		public void SpecialTestingCost_Fail()
		{
			this._tstBUF.SpecialTestingCost = BOL.BloodUnitFinance.MaximumSpecialTestCost + 1;

			Assert.IsTrue(this._tstBUF.IsRuleBroken(BROKEN.SpecialTestingCost));
		}
		

		[Test]
		public void ReturnCreditAmount_Pass()
		{
			this._tstBUF.ReturnCreditAmount = (decimal)50;
			Assert.IsTrue(this._tstBUF.IsRuleBroken(BROKEN.ReturnCreditAmount) == false);		
		}

		[Test]
		public void ReturnCreditAmount_Fail()
		{
			this._tstBUF.ReturnCreditAmount = BOL.BloodUnitFinance.MaximumReturnCreditAmount + 1;

			Assert.IsTrue(this._tstBUF.IsRuleBroken(BROKEN.ReturnCreditAmount));
		}

		[Test]
		public void IsReturnCreditAmountNull_Pass()
		{
			bool tstValue = this._tstBUF.IsReturnCreditAmountNull;
			Assert.IsTrue(this._tstBUF.IsReturnCreditAmountNull == tstValue);		
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void IsReturnCreditAmountNull_Fail()
		{
		}

		[Test]
		public void IsUnitCostNull_Pass()
		{
			bool tstValue = this._tstBUF.IsReturnCreditAmountNull;
			Assert.IsTrue(this._tstBUF.IsReturnCreditAmountNull == tstValue);		
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void IsUnitCostNull_Fail()
		{
		}

		[Test]
		public void IsSpecialTestingCostNull_Pass()
		{
			bool tstValue = this._tstBUF.IsReturnCreditAmountNull;
			Assert.IsTrue(this._tstBUF.IsReturnCreditAmountNull == tstValue);		
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void IsSpecialTestingCostNull_Fail()
		{
		}

		[Test]
		public void RowVersion_Pass()
		{
			byte[] tstValue = this._tstBUF.RowVersion;
			Assert.IsTrue(this._tstBUF.RowVersion == tstValue);	
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void RowVersion_Fail()
		{
		}

	}

}
#endif
